/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.components.table.IExtendedTableModel;
import com.ibm.psw.wcl.components.table.ITableFilter;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.components.table.WTableColumn;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.ExtendedListSelectionEvent;
import com.ibm.psw.wcl.core.IExtendedListSelectionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelListener;

public class WclGlueTableModel
implements IExtendedTableModel {
    public static final String TRACE_MASKT = "XPMWGLTT";
    public static final String TRACE_MASKF = "XPMWGLTF";
    private static final int[] EMPTY_SELECTION = new int[0];
    private boolean dirty = false;
    private PmTableModel model = null;
    private List tableModelListeners = null;
    private List listSelectionListeners = null;
    private int selectionMode = 0;
    private int leadIndex = -1;
    private int anchorIndex = -1;
    private int[] viewRowIndicies;
    private WTable wTable;

    public WclGlueTableModel(PmTableModel model) {
        this.model = model;
        this.tableModelListeners = new ArrayList();
        this.listSelectionListeners = new ArrayList();
        this.dirty = true;
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.model.setValueAt(value, rowIndex, columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(rowIndex, columnIndex);
    }

    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(rowIndex, columnIndex);
    }

    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.tableModelListeners.add(l);
        }
    }

    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.tableModelListeners.remove(l);
        }
    }

    public boolean isSelectedIndex(int index) {
        int[] selected = this.model.getSelected();
        int newIndex = this.getModelRowIndex(index);
        if (selected != null) {
            for (int i = 0; i < selected.length; ++i) {
                if (selected[i] != newIndex) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectionInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "setSelectionInterval(" + index0 + "," + index1 + ")");
        index0 = this.getModelRowIndex(index0);
        index1 = this.getModelRowIndex(index1);
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearSelection(ac);
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSel = new int[++newSelIntervalSize];
            for (int i = 0; i < newSelIntervalSize; ++i) {
                newSel[i] = index0 == index1 ? index0 : (index0 < index1 ? index0 + i : index1 + i);
            }
            if (!Arrays.equals(currentSel, newSel)) {
                this.anchorIndex = index0;
                this.leadIndex = index1;
                this.model.setSelected(newSel);
                ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, index0, index1, ac);
                Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
                while (iterator.hasNext()) {
                    IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
        }
    }

    public void addSelectionInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "addSelectionInterval(" + index0 + "," + index1 + ")");
        index0 = this.getModelRowIndex(index0);
        index1 = this.getModelRowIndex(index1);
        if (this.selectionMode != -1) {
            int newSelIntervalSize;
            int[] currentSel = this.getSelectedRows();
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearSelection(ac);
                currentSel = EMPTY_SELECTION;
            }
            if ((newSelIntervalSize = index0 - index1) < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSelAddition = new int[++newSelIntervalSize];
            for (int i = 0; i < newSelAddition.length; ++i) {
                newSelAddition[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
            }
            int uniqueEntries = currentSel.length;
            for (int i = 0; i < newSelAddition.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != newSelAddition[i]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (found) continue;
                ++uniqueEntries;
            }
            int[] newSelection = new int[uniqueEntries];
            System.arraycopy(currentSel, 0, newSelection, 0, currentSel.length);
            uniqueEntries = currentSel.length;
            for (int i = 0; i < newSelAddition.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != newSelAddition[i]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (found) continue;
                newSelection[uniqueEntries++] = newSelAddition[i];
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.model.setSelected(newSelection);
                ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, index0, index1, ac);
                Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
                while (iterator.hasNext()) {
                    IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
        }
    }

    public void clearSelection(AContext ac) {
        Trace.trace(TRACE_MASKT, "clearSelection()");
        if (this.selectionMode != -1) {
            this.model.setSelected(EMPTY_SELECTION);
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, -1, -1, ac);
            Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }

    public void removeSelectionInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "removeSelectionInterval(" + index0 + "," + index1 + ")");
        index0 = this.getModelRowIndex(index0);
        index1 = this.getModelRowIndex(index1);
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
            }
            int[] currentSel = this.getSelectedRows();
            int remSelIntervalSize = index0 - index1;
            if (remSelIntervalSize < 0) {
                remSelIntervalSize *= -1;
            }
            int[] selSubtraction = new int[++remSelIntervalSize];
            for (int i = 0; i < selSubtraction.length; ++i) {
                selSubtraction[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
            }
            int uniqueEntries = currentSel.length;
            for (int i = 0; i < selSubtraction.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != selSubtraction[i]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (!found) continue;
                --uniqueEntries;
            }
            int[] newSelection = new int[uniqueEntries];
            uniqueEntries = 0;
            for (int i = 0; i < currentSel.length; ++i) {
                boolean found = false;
                for (int j = 0; j < selSubtraction.length; ++j) {
                    if (currentSel[i] != selSubtraction[j]) continue;
                    found = true;
                    j = selSubtraction.length;
                }
                if (found) continue;
                newSelection[uniqueEntries++] = currentSel[i];
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.model.setSelected(newSelection);
                ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, index0, index1, ac);
                Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
                while (iterator.hasNext()) {
                    IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
        }
    }

    public int getMinSelectionIndex() {
        int[] selected = this.model.getSelected();
        if (selected != null && selected.length > 0) {
            return selected[0];
        }
        return -1;
    }

    public int getMaxSelectionIndex() {
        int[] selected = this.model.getSelected();
        if (selected != null && selected.length > 0) {
            return selected[selected.length - 1];
        }
        return -1;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void addListSelectionListener(IExtendedListSelectionListener x) {
        if (x != null) {
            this.listSelectionListeners.add(x);
        }
    }

    public boolean isSelectionEmpty() {
        int[] selected = this.model.getSelected();
        return selected == null || selected.length == 0;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectedRowCount() {
        int[] selected = this.getSelectedModelRows();
        int count = 0;
        for (int i = 0; i < selected.length; ++i) {
            if (this.getViewRowIndex(selected[i]) == Integer.MAX_VALUE) continue;
            ++count;
        }
        return count;
    }

    public int[] getSelectedModelRows() {
        int[] selected = this.model.getSelected();
        return selected == null ? EMPTY_SELECTION : selected;
    }

    public void removeListSelectionListener(IExtendedListSelectionListener x) {
        if (x != null) {
            this.listSelectionListeners.remove(x);
        }
    }

    public int[] getSelectedRows() {
        int[] selected = this.model.getSelected();
        if (this.viewRowIndicies == null) {
            return selected;
        }
        int[] viewSelected = new int[selected.length];
        int j = 0;
        for (int i = 0; i < selected.length; ++i) {
            if (this.getViewRowIndex(selected[i]) == Integer.MAX_VALUE) continue;
            viewSelected[j++] = selected[i];
        }
        int[] finalSelected = new int[j];
        System.arraycopy(viewSelected, 0, finalSelected, 0, j);
        return finalSelected;
    }

    public void selectAll(AContext ac) {
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                if (this.model.getRowCount() > 0) {
                    this.model.setSelected(new int[]{0});
                }
            } else {
                int[] newSel = new int[this.model.getRowCount()];
                for (int i = 0; i < newSel.length; ++i) {
                    newSel[i] = i;
                }
                this.model.setSelected(newSel);
            }
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, 0, this.model.getRowCount(), ac);
            Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }

    public int getModelRowIndex(int viewRow) {
        return this.viewRowIndicies == null ? viewRow : this.viewRowIndicies[viewRow];
    }

    public int getSelectedModelRowCount() {
        int[] currentSel = this.model.getSelected();
        return currentSel == null ? 0 : currentSel.length;
    }

    public boolean isSelectedModelIndex(int index) {
        int[] currentSel = this.model.getSelected();
        if (currentSel == null) {
            return false;
        }
        for (int i = 0; i < currentSel.length; ++i) {
            if (currentSel[i] != index) continue;
            return true;
        }
        return false;
    }

    public int getTotalRows() {
        return this.model.getRowCount();
    }

    public void tableStateChanged(int stateID, WTable table) {
        int i;
        this.wTable = table;
        if (this.viewRowIndicies == null || stateID == 0 || stateID == 1 || stateID == 2) {
            this.viewRowIndicies = new int[this.getTotalRows()];
        }
        WTableColumn[] filteredColumns = table.getFilteredColumns();
        int[] filterIndicies = new int[filteredColumns.length];
        for (i = 0; i < filterIndicies.length; ++i) {
            filterIndicies[i] = filteredColumns[i].getModelIndex();
        }
        for (i = 0; i < this.viewRowIndicies.length; ++i) {
            this.viewRowIndicies[i] = i;
            for (int j = 0; j < filteredColumns.length; ++j) {
                ITableFilter filter = filteredColumns[j].getFilter();
                if (filter.matches(this.model.getValueAt(i, filterIndicies[j]))) continue;
                this.viewRowIndicies[i] = Integer.MAX_VALUE;
                j = filteredColumns.length;
            }
        }
        WTableColumn[] sortedColumns = table.getSortedColumns();
        int[] sortIndicies = new int[sortedColumns.length];
        for (int i2 = 0; i2 < sortIndicies.length; ++i2) {
            sortIndicies[i2] = sortedColumns[i2].getModelIndex();
        }
        this.quicksort(0, this.viewRowIndicies.length - 1, sortedColumns, sortIndicies);
        if (this.tableModelListeners.size() > 0) {
            this.setStateDirty(false);
        } else {
            this.setStateDirty(true);
        }
    }

    private void quicksort(int low, int high, WTableColumn[] sortedColumns, int[] sortIndicies) {
        if (high > low) {
            int pivot = this.partition(low, high, sortedColumns, sortIndicies);
            this.quicksort(low, pivot - 1, sortedColumns, sortIndicies);
            this.quicksort(pivot + 1, high, sortedColumns, sortIndicies);
        }
    }

    private int partition(int low, int high, WTableColumn[] sortedColumns, int[] sortIndicies) {
        int swap;
        int j = low;
        for (int i = low + 1; i <= high; ++i) {
            if (this.isSorted(this.viewRowIndicies[i], this.viewRowIndicies[low], sortedColumns, sortIndicies)) continue;
            swap = this.viewRowIndicies[i];
            this.viewRowIndicies[i] = this.viewRowIndicies[++j];
            this.viewRowIndicies[j] = swap;
        }
        int pivot = j;
        swap = this.viewRowIndicies[low];
        this.viewRowIndicies[low] = this.viewRowIndicies[pivot];
        this.viewRowIndicies[pivot] = swap;
        return pivot;
    }

    private boolean isSorted(int row1, int row2, WTableColumn[] sortedColumns, int[] sortIndicies) {
        try {
            for (int i = 0; i < sortedColumns.length; ++i) {
                int compValue;
                Object o1 = this.model.getValueAt(row1, sortIndicies[i]);
                Object o2 = this.model.getValueAt(row2, sortIndicies[i]);
                Comparator comparator = sortedColumns[i].getComparator();
                if (comparator == null) {
                    comparator = Collator.getInstance();
                }
                if ((compValue = comparator.compare(o1, o2)) == 0) continue;
                if (sortedColumns[i].isSortedAscending() && compValue > 0) {
                    return false;
                }
                if (sortedColumns[i].isSortedAscending() || compValue >= 0) continue;
                return false;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        return true;
    }

    public int getViewRowIndex(int modelRow) {
        if (this.viewRowIndicies == null) {
            Trace.trace(TRACE_MASKT, "getViewRowIndex(" + modelRow + "): " + modelRow);
        }
        for (int i = 0; i < this.viewRowIndicies.length; ++i) {
            if (this.viewRowIndicies[i] != modelRow) continue;
            Trace.trace(TRACE_MASKT, "getViewRowIndex(" + modelRow + "): " + i);
            return i;
        }
        return modelRow;
    }

    public int getViewRowCount() {
        int totalRows = this.getTotalRows();
        if (this.viewRowIndicies == null) {
            return totalRows;
        }
        if (totalRows != this.viewRowIndicies.length) {
            if (this.wTable != null) {
                this.tableStateChanged(0, this.wTable);
            } else {
                return totalRows;
            }
        }
        int count = 0;
        for (int i = 0; i < this.viewRowIndicies.length; ++i) {
            if (this.viewRowIndicies[i] == Integer.MAX_VALUE) continue;
            ++count;
        }
        return count;
    }

    public void setStateDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isStateDirty() {
        return this.dirty;
    }
}

